; Mouse1.asm - displays mouse buttons pressed and co-ordinates
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Mouse reader',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_hdc
	struclocal	_rect, RECT, _ps, PAINTSTRUCT
	ddstatic	_ddX, _ddY
	endlocals
	;
	; _szOutputString holds the string to paint
	;
	TEXTlocal	_szOutputString, '                                       ',0
	;
	CallbackPrologue
	;
	switch .message
		case WM_PAINT
			sc BeginPaint, .hwnd, ._ps
			mov	._hdc, eax
			sc GetClientRect, .hwnd, ._rect
			sc DrawText, ._hdc, ._szOutputString, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER
			sc EndPaint, .hwnd, ._ps
			xor	eax, eax
			break
		case WM_LBUTTONDOWN
			;
			; A WM_LBUTTONDOWN message is sent whenever the left mouse button is
			; pressed. Like the other mouse messages (WM_LBUTTONUP, WM_LBUTTONDBLCLK
			; for the left button, WM_RBUTTONDOWN, WM_RBUTTONUP, WM_RBUTTONDBLCLK for
			; the right button, WM_MBUTTONDOWN, WM_MBUTTONUP, WM_MBUTTONDBLCLK for
			; the middle one and WM_MOUSEMOVE for any mouse movement) lParam holds
			; the coordinates (x in the lower word, y in the upper) and wParam holds
			; the mouse button state and the shift/control key states. These states
			; can be determined via masks which are called:
			;
			; MK_LBUTTON / MK_MBUTTON / MK_RBUTTON - button is pressed
			; MK_SHIFT / MK_CONTROL - shift / control key is pressed
			;
			; Since they're masks, just AND wParam with whatever it is you want to
			; check for.
			;
			; In this simple example, I've not checked for WM_MOUSEMOVE messages,
			; which are sent as the mouse moves. It would be easy to write the extra
			; code for this, but it would obscure the button messages. As an exercise,
			; write the extra code to process WM_MOUSEMOVE messages, however don't
			; just put the string holding the coords into lpOutputString. Instead,
			; create a new buffer and in WM_PAINT output this buffer to the top of
			; the screen so it doesn't obscure the other messages.
			;
			; The code will go in a macro below so I'll describe the steps here:
			;
			; Step 1:
			; get the x and y coords into two variables, note that these co-ords are
			; relative to the client area and not the screen
			;
			; Step 2:
			; now call wvsprintf to generate the correct string. wvsprintf is a
			; useful API call, that works in much the same way as printf in C. It
			; takes three parameters - a buffer for the resulting string, a null-
			; terminated string to process and a pointer to an array of values
			; for the parameters. In our case, the string to process looks like
			; 'Left-button pressed, X=%i, Y=%i' The %i's represent where our
			; parameters are to go (%i = signed decimal integer (the same as %d
			; in fact)). Since our variables are declared next to each other we
			; can treat the two as an (albeit very small) array with the first
			; variable being the start and pass this as the array address. See
			; the help file for more information on this very useful call. Note
			; that this is the sort of often-used routine that's a pain to write
			; in assembler.
			;
			; Handily, wvsprintf also appends a null-terminator to the end of the
			; string and returns the resulting string length (excluding the
			; terminator)
			;
			; Step 3:
			; tell Windows to redraw the window
			;
			%macro SetMessage 1
				mov	ecx, .lParam		; loword=x, hiword=y
				movsx	eax, cx			; get loword in ax
				shr	ecx, 16
				movsx	ebx, cx			; get hiword in bx
				mov	._ddX, eax
				mov	._ddY, ebx
				sc wvsprintf, ._szOutputString, %1, .._ddX
				sc InvalidateRect, .hwnd, NULL, TRUE
				xor	eax, eax
			%endmacro
			TEXTlocal _szLeftDown, 'Left-button pressed, X=%i, Y=%i',0
			SetMessage ._szLeftDown
			break
		case WM_LBUTTONUP
			TEXTlocal _szLeftUp, 'Left-button released, X=%i, Y=%i',0
			SetMessage ._szLeftUp
			break
		case WM_LBUTTONDBLCLK
			;
			; You should note that though there's a specific double-click message,
			; the actual messages sent are:
			;
			; WM_LBUTTONDOWN
			; WM_LBUTTONUP
			; WM_LBUTTONDBLCLK
			; WM_LBUTTONUP
			;
			; Hence, even though you probably can't see it in this example the
			; WM_LBUTTONDOWN code is being processed before WM_LBUTTONDBLCLK.
			; In real-world applications, you might need to worry about this.
			; Most programs simply make the first click of a double-click do
			; the same thing as a single click and you can probably do the same.
			;
			TEXTlocal _szLeftDouble, 'Left double-click, X=%i, Y=%i',0
			SetMessage ._szLeftDouble
			break
		case WM_RBUTTONDOWN
			TEXTlocal _szRightDown, 'Right-button pressed, X=%i, Y=%i',0
			SetMessage ._szRightDown
			break
		case WM_RBUTTONUP
			TEXTlocal _szRightUp, 'Right-button released, X=%i, Y=%i',0
			SetMessage ._szRightUp
			break
		case WM_RBUTTONDBLCLK
			TEXTlocal _szRightDouble, 'Right double-click, X=%i, Y=%i',0
			SetMessage ._szRightDouble
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax,eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	;
	CallbackEpilogue
endproc

[section .bss]

[section .data]
